unit CraphCommomTools;

interface
uses Types, Graphics;

//    

type TImgItm = record
     SrcRect : Trect;
     BitMap  : TBitMap;
end;



//    
function EqualPoints(const P1, P2: TPoint): Boolean;
//     TRect
function RectIsNoarmal(RqRect : TRect) : boolean;
//      TRect
function NoarmalRect (RqBeg, RqEnd : TPoint) : TRect;

implementation

// -----------------------------------------------------------------------
//  UNIT : Types
// -----------------------------------------------------------------------
//    
function EqualPoints(const P1, P2: TPoint): Boolean;
begin
  Result := (P1.X = P2.X) and (P1.Y = P2.Y);
end;

//     TRect
function RectIsNoarmal(RqRect : TRect) : boolean;
begin
 Result := False;
 if (RqRect.Right >= RqRect.Left) and (RqRect.Bottom >= RqRect.Top)
 //   Rect        ?
 then Result := True;
end; // of function

//      TRect
function NoarmalRect (RqBeg, RqEnd : TPoint) : TRect;
begin
   if RqEnd.X < RqBeg.X
   then
      // 1.     - 
      if RqEnd.Y < RqBeg.Y
      then
         // 1.1.     - 
         Result := Rect(RqEnd.X, RqEnd.Y, RqBeg.X, RqBeg.Y )
      else
         // 1.2.     - 
         Result := Rect(RqEnd.X, RqBeg.Y, RqBeg.X, RqEnd.Y )
   else
      // 2     -  ()
      if RqEnd.Y < RqBeg.Y
      then
         // 2.1.     - 
         Result := Rect(RqBeg.X, RqEnd.Y, RqEnd.X, RqBeg.Y )
      else
         // 2.2.     -  ()
         Result := Rect(RqBeg.X, RqBeg.Y, RqEnd.X, RqEnd.Y );
end; // of function



end.
